package org.msh.tb.bd.tbforms.dhis2.config;

import org.jboss.seam.Component;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.msh.tb.application.tasks.AsyncTask;
import org.msh.tb.application.tasks.TaskManager;
import org.msh.tb.bd.tbforms.dhis2.DHIS2AuthenticationService;
import org.msh.tb.entities.UserWorkspace;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by Mauricio on 14/03/2017.
 * Controller class to track the execution of data elements config async task
 */
@Name("dhis2DataElementsConfigHome")
public class DHIS2DataElementsConfigHome {

    @In(create=true)
    protected DHIS2AuthenticationService dHIS2AuthenticationService;

    @In(create=true)
    protected DHIS2DataElementConfigService dhis2DataElementsConfigService;

    @In
    TaskManager taskManager;

    public void configure(){
        if (getTask() != null) {
            throw new RuntimeException("The configuration task is already running");
        }

        Map<String, Object> params =  new HashMap<String, Object>();

        // set params
        params.put(DHIS2DataElementsConfigAsyncTask.PARAM_DHIS2_AUTH_SERVICE, dHIS2AuthenticationService);
        params.put(DHIS2DataElementsConfigAsyncTask.PARAM_DHIS2_CONFIG_SERVICE, dhis2DataElementsConfigService);

        taskManager.runTask(DHIS2DataElementsConfigAsyncTask.class, params);
    }

    public Double getProgress() {
        AsyncTask task = getTask();

        // task is not running
        if (task == null) {
            return null;
        }

        return task.getProgress();
    }

    private AsyncTask getTask() {
        return taskManager.findTaskByClass(DHIS2DataElementsConfigAsyncTask.class);
    }

    private UserWorkspace getUserWorkspace() {
        return ((UserWorkspace) Component.getInstance("userWorkspace", true));
    }

}
